<?php

namespace Allocine\DbzModelBundle\Tests\Type\Social\UserHasReview\Data;

use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data\Moderation;
use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data\Reason;
use Allocine\DbzModelBundle\Tests\KernelTestCase;
use Psr\Log\LoggerInterface;

class ModerationTest extends KernelTestCase
{
    public function testConstructorIdReason()
    {
        $moderation = new Moderation([
            'id_reason' => 1,
        ]);

        $this->assertEquals(1, $moderation->id_reason);

        // With an invalid ID, we should now use UNKNOWN_REASON
        $moderation = new Moderation([
            'id_reason' => 6,
        ]);

        $this->assertEquals(Reason::UNKNOWN_REASON, $moderation->id_reason);
    }

    public function testSetIdReason()
    {
        foreach ([
            0,
            1,
            2,
            3,
            4,
            5,
            8,
            12,
            14,
            20,
            21,
            23,
            24,
            99,
            100,
            101,
            102,
            103,
            104,
            105,
            106,
            107,
            108,
            109,
        ] as $idReason)
        {
            $moderation = new Moderation();
            $moderation->id_reason = $idReason;

            $this->assertEquals($idReason, $moderation->id_reason);
        }

        // With an invalid ID, we should now use UNKNOWN_REASON
        $moderation = new Moderation();
        $moderation->id_reason = 'AAAA';
        $this->assertEquals(Reason::UNKNOWN_REASON, $moderation->id_reason);
    }

    public function testUnknownIdReasonLogsWarning()
    {
        // Create a mock for the logger
        $logger = $this->createMock(LoggerInterface::class);

        // Set expectations for the mock
        $logger->expects($this->once())
               ->method('warning')
               ->with(
                   $this->equalTo("Unknown Netino reason ID encountered"),
                   $this->callback(function ($context) {
                       return $context['value'] === 999;
                   })
               );

        // Create Moderation object with the mocked logger
        $moderation = new Moderation([], $logger);

        // Set an unknown reason ID
        $moderation->id_reason = 999;

        // Verify that the ID has been replaced with UNKNOWN_REASON
        $this->assertEquals(Reason::UNKNOWN_REASON, $moderation->id_reason);
    }
}
