<?php

namespace Allocine\DbzModelBundle\Tests\Type\Brand\EntityHasOverride;

use Allocine\DbzModelBundle\Internal\Type\Brand\EntityHasOverride\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a entityHasOverride data with no field

        $entityHasOverrideData = new Data('{}');

        $this->assertTrue($entityHasOverrideData->seo->browsable);
        $this->assertNull($entityHasOverrideData->seo->title);
        $this->assertNull($entityHasOverrideData->seo->alternate_title);
        $this->assertNull($entityHasOverrideData->seo->description);

        // Create a full entityHasOverride data

        $entityHasOverrideData = new Data([
            'seo' => [
                'browsable' => false,
                'title' => 'title 1',
                'alternate_title' => 'title 2',
                'description' => 'description 1',
            ],
        ]);

        $this->assertFalse($entityHasOverrideData->seo->browsable);
        $this->assertEquals('title 1', $entityHasOverrideData->seo->title);
        $this->assertEquals('title 2', $entityHasOverrideData->seo->alternate_title);
        $this->assertEquals('description 1', $entityHasOverrideData->seo->description);

        // Create a entityHasOverride with an invalid field

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [alternateTitle] for constrained object [Allocine\DbzModelBundle\Internal\Type\Brand\EntityHasOverride\Data\Seo'
        );

        new Data([
            'seo' => [ 'alternateTitle' => 'PAN' ]
        ]);
    }
}
