<?php

namespace Allocine\DbzModelBundle\Tests\Model;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Allocine\DbzModelBundle\Model\Movie\Movie;
use Allocine\DbzModelBundle\Model\Movie\MovieModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;
use PommProject\ModelManager\Model\Model;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;

class MasterSlaveTest extends KernelTestCase
{
    private $slaveServiceIds = [
        MovieModel::class,
        'dbz.model.movie.movie.slave',
        'dbz.model.movie.movie',
    ];

    private $masterServiceIds = [
        'dbz.model.movie.movie.master',
    ];

    public function testSlaveModel()
    {
        foreach ($this->slaveServiceIds as $servicesId) {
            $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, static::$container->get($servicesId));
        }

        $publicService = static::$kernel->getContainer()->get('test.testable_services');
        $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[0]);
        $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[1]);
        $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[2]);
    }

    public function testMasterModel()
    {
        foreach ($this->masterServiceIds as $servicesId) {
            $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, static::$container->get($servicesId));
        }

        $publicService = static::$kernel->getContainer()->get('test.testable_services');
        $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, $publicService[3]);
    }

    public function testServicesArePrivate()
    {
        $errors = [];
        foreach(array_merge($this->slaveServiceIds, $this->masterServiceIds) as $serviceId) {
            try {
                static::$kernel->getContainer()->get($serviceId);
                $errors[] = sprintf(
                    'Retrieving service [%s] should throw a [ServiceNotFoundException], nothing thrown.',
                    $serviceId
                );
            } catch (ServiceNotFoundException $e) {
            } catch (\Exception $e) {
                $errors[] = sprintf(
                    'Retrieving service [%s] should throw a [ServiceNotFoundException], thrown [%s].',
                    $serviceId,
                    get_class($e)
                );
            }
        }

        if (!empty($errors)) {
            $this->fail(implode("\n", $errors));
        } else {
            $this->assertTrue(true);
        }
    }

    private function assertSameSessionName(string $expected, Model $model)
    {
        return $this->assertSame($expected, $model->getSession()->getStamp());
    }
}
