<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic\Office;

use Allocine\Titania\Type\Base\ObjectCollection;

class DepartmentCollection extends ObjectCollection
{
    protected $internalObjectClass = Department::class;

    /**
     * @return array
     */
    public function getExistingDepartmentNames() : array
    {
        $ret = [];

        foreach ($this as $department) {
            if (! array_key_exists($department->name, $ret)) {
                $ret[$department->name] = true;
            }
        }

        return array_keys($ret);
    }
}
