<?php

namespace Allocine\DbzModelBundle\Internal\Type\DarkZone\Lost;

use Allocine\DbzModelBundle\Internal\Type\DarkZone\Lost\MatchingData\ImageCollection;
use Allocine\DbzModelBundle\Internal\Type\DarkZone\Lost\MatchingData\LocalizedTitleCollection;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property string $title
 * @property string $episode_title
 * @property LocalizedTitleCollection localized_titles
 * @property string[] $actors
 * @property string[] $directors
 * @property int $season_number
 * @property int $episode_number
 * @property int $production_year
 * @property int $runtime
 * @property string $released_at
 * @property string $unreleased_at
 * @property string $released_at_time
 * @property ImageCollection $images
 * @property string[] $genres
 * @property string[] info
 */
class MatchingData extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'title' => null,
            'localized_titles' => [],
            'actors' => [],
            'directors' => [],
            'season_number' => null,
            'episode_number' => null,
            'episode_title' => null,
            'production_year' => null,
            'runtime' => null,
            'released_at' => null,
            'released_at_time' => null,
            'unreleased_at' => null,
            'images' => [],
            'genres' => [],
            'info' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'localized_titles' => new ClassDefinition([
                'class' => LocalizedTitleCollection::class,
            ]),
            'images' => new ClassDefinition([
                'class' =>  ImageCollection::class,
            ]),
        ];
    }
}
