<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\BrandHasMovie;

use Allocine\DbzModelBundle\Internal\Type\Generic\Data\Seo;
use Allocine\DbzModelBundle\Internal\Type\Brand\BrandHasMovie\Data\Advice;
use Allocine\DbzModelBundle\Internal\Type\Brand\BrandHasMovie\Data\Ruling;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'seo' => [],
            'advice' => [],
            'ruling' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'seo' => new ClassDefinition([
                'class' =>  Seo::class,
            ]),
            'advice' => new ClassDefinition([
                'class' =>  Advice::class,
            ]),
            'ruling' => new ClassDefinition([
                'class' =>  Ruling::class,
            ]),
        ];
    }
}
