<?php

namespace Allocine\DbzModelBundle\Internal\Converter\DarkZone\Lost;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\DarkZone\Lost\MatchingData
    as MatchingDataType;

class MatchingData implements ConverterInterface
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        return new MatchingDataType($data);
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
