<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Company;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Office\OfficeCollection as OfficeCollectionType;

class OfficeCollection implements ConverterInterface
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        return new OfficeCollectionType($data);
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
