<?php

namespace Allocine\DbzModelBundle\Tests;

use Allocine\DbzModelBundle\Model\Movie\MovieModel;

class ModelServicesTest extends KernelTestCase
{
    /**
     * A service model can be injected in many ways.
     */
    public function testInjectedPrivateModel()
    {
        // From a private alias into an ArrayObject public service
        $fake = static::$container->get('test.testable_services');
        $this->assertInstanceOf(MovieModel::class, $fake[0]);

        // From the fully qualified name of the service (class) into a public service
        $fake = static::$container->get('test.fake_service');
        $this->assertInstanceOf(MovieModel::class, $fake->getModel());

        // From the generated private alias into a public service
        $fake = static::$container->get('test.fake_service_with_alias');
        $this->assertInstanceOf(MovieModel::class, $fake->getModel());
    }

    /**
     * An alias of the base model service should not be accessible directy.
     */
    public function testAccessYmlModelFail()
    {
        $this->assertFalse(static::$container->initialized('test.movie_model.configured_alias'));
    }
}
