<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandPersonMonth as BrandPersonMonthStructure;

/**
 * BrandPersonMonthModel
 *
 * Model class for table brand_person_month.
 *
 * @see Model
 */
class BrandPersonMonthModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandPersonMonthStructure;
        $this->flexible_entity_class = BrandPersonMonth::class;
    }
}
