<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\FestivalEdition as FestivalEditionStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * FestivalEditionModel
 *
 * Model class for table festival_edition.
 *
 * @see Model
 */
class FestivalEditionModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new FestivalEditionStructure;
        $this->flexible_entity_class = FestivalEdition::class;
    }
}
