<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * FestivalEdition
 *
 * Structure class for relation brand.festival_edition.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 *
 *
 *
 * @see RowStructure
 */
class FestivalEdition extends RowStructure
{
    /**
     * __construct
     *
     * Structure definition.
     *
     * @access public
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.festival_edition')
            ->setPrimaryKey(['id'])
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('active', 'bool')
            ->addField('gid', 'public.global_id')
            ->addField('id', 'int8')
            ->addField('locale', 'text')
            ->addField('name', 'text')
            ->addField('original_name', 'text')
            ->addField('starts_at', 'public.partial_date')
            ->addField('ends_at', 'public.partial_date')
            ->addField('year', 'int4')
            ->addField('edition_number', 'int2')
            ->addField('id_festival', 'int8')
            ->addField('id_poster', 'int8')
            ->addField('data', 'jsonb')
            ->addField('localization_created_at', 'timestamp')
            ->addField('localization_id_created_by', 'int4')
            ->addField('localization_updated_at', 'timestamp')
            ->addField('localization_id_updated_by', 'int4')
        ;
    }
}
