<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasPerson.
 *
 * Structure class for relation brand.brand_has_person.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasPerson extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_person')
            ->setPrimaryKey(['id_person', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'brand.brand_has_person.data')
            ->addField('id_brand', 'bpchar')
            ->addField('id_person', 'int8')
            ->addField('biography', 'text')
            ->addField('biography_hash', 'bpchar')
            ->addField('biography_json', 'jsonb')
            ->addField('biography_short', 'text')
            ->addField('id_poster', 'int8')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @param string $name
     * @return string
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor($name)
    {
        if (in_array($name, [ 'data' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }

}
