<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Brand\BrandHasPerson;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Brand\BrandHasPerson\Data as DataType;

class Data implements ConverterInterface
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        return new DataType($data);
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
