<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\Command\FixturesLoadCommand;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class FixtureProcessorsPass implements CompilerPassInterface
{
    const TAG_NAME = 'dbz.fixture_processor';

    public function process(ContainerBuilder $container)
    {
        $fixtureCommand = $container->getDefinition(FixturesLoadCommand::class);

        foreach (array_keys($container->findTaggedServiceIds(self::TAG_NAME)) as $service) {
            $fixtureCommand->addMethodCall(
                'addProcessor',
                [new Reference($service)]
            );
        }
    }
}
