<?php

namespace Allocine\DbzModelBundle\Tests\Type\Executive\Company;

use Allocine\DbzModelBundle\Internal\Type\Generic\Office\OfficeCollection;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class OfficeCollectionTest extends KernelTestCase
{
    public function testGetExistingCompanyNames()
    {
        // Empty collection

        $officeCollection = new OfficeCollection([]);

        $this->assertEquals([], $officeCollection->getExistingDepartmentNames());

        // Full collection

        $officeCollection = new OfficeCollection([
            [
                'name' => 'Office 1',
                'departments' => [
                    [ 'name' => 'Dept 1' ],
                    [ 'name' => 'Dept 2' ],
                    [ 'name' => 'Dept 3' ]
                ]
            ], [
                'name' => 'Office 2',
                'departments' => [
                    [ 'name' => 'Dept 1' ],
                    [ 'name' => 'Dept 4' ],
                    [ 'name' => 'Dept 5' ]
                ]
            ], [
                'name' => 'Office 3',
                'departments' => [
                    [ 'name' => 'Dept 2' ]
                ]
            ]
        ]);

        $this->assertEquals(
            [
                'Dept 1',
                'Dept 2',
                'Dept 3',
                'Dept 4',
                'Dept 5',
            ],
            $officeCollection->getExistingDepartmentNames()
        );
    }
}
