<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserFollowCollectionModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserFollowCollectionModelTest extends KernelTestCase
{
    /**
     * @var UserFollowCollectionModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserFollowCollectionModel::class)
        ;
    }

    /**
     *
     */
    public function testCountByUser()
    {
        $expected = [
            2000000000 => 2,
            2000000001 => 0,
            2000000002 => 4,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByUser($user)
            );
        }
    }

}
