<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Domains\Tag3DCollection;
use PommProject\ModelManager\Model\FlexibleEntity;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * Flexible entity for relation
 * secure.user
 *
 * @property int id
 * @property string name
 * @property string email
 * @property Tag3DCollection tags
 * @property bool active
 * @property \DateTime created_at
 * @property int id_created_by
 * @property \DateTime updated_at
 * @property int id_updated_by
 * @property string origin
 * @property array data
 * @property string gid
 * @property array alt
 * @property bool admin
 */
class User extends FlexibleEntity
{
    /**
     * @inheritDoc
     */
    public function getRoles()
    {
        $roles = ['ROLE_USER'];

        if ($this->has('admin') && $this->get('admin')) {
            $roles[] = 'ROLE_SUPER_ADMIN';
        }

        return $roles;
    }

    /**
     * @inheritDoc
     */
    public function getUsername()
    {
        return $this->get('email');
    }

    /**
     * @inheritDoc
     */
    public function eraseCredentials()
    {
        // Do not erase the password otherwise it will be persisted!
    }
}
