<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Company as CompanyStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * Company.Model.
 *
 * Model class for table company.
 *
 * @see Model
 */
class CompanyModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new CompanyStructure();
        $this->flexible_entity_class = Company::class;
    }
}
