<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasCompany.
 *
 * Structure class for relation brand.brand_has_company.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasCompany extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_company')
            ->setPrimaryKey(['id_company', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'generic.data_with_seo')
            ->addField('id_brand', 'bpchar')
            ->addField('id_company', 'int8')
            ->addField('name', 'text')
            ->addField('description', 'text')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @param string $name
     * @return string
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor($name)
    {
        if (in_array($name, [ 'data' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }

}
