<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Moderation
 * @package Allocine\DbzModelBundle\Internal\Type\Social\User\Data
 *
 * @property int id_reason
 * @property string reason
 * @property string message
 * @property \DateTime banned_until
 *
 */
class Moderation extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'id_reason'=> null,
            'reason' => null,
            'message' => null,
            'banned_until' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'banned_until' => new ClassDefinition([
                'class' => \DateTime::class,
                'nullable' => true
            ]),
        ];
    }

    /**
     * @inheritDoc
     * @throws LogicException
     */
    public function setAttribute($name, $value)
    {
        if ('id_reason' === $name) {
            if (! Reason::isValidValue($value)) {
                throw new \LogicException(
                    "Value $value is not permited for Netino's id_reason."
                );
            }
        }

        return parent::setAttribute($name, $value);
    }
}
