<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data;

use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Product\Online;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Product\Physical;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Provider\Provider;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property Online $online
 * @property Physical $physical
 */
class Product extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'online' => [],
            'physical' => [],
            'provider' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'online' => new ClassDefinition([
                'class' =>  Online::class,
            ]),
            'physical' => new ClassDefinition([
                'class' =>  Physical::class,
            ]),
            'provider' => new ClassDefinition([
                'class' =>  Provider::class,
            ]),
        ];
    }
}
