<?php

namespace Allocine\DbzModelBundle\Tests\Type\Executive\Company;

use Allocine\DbzModelBundle\Internal\Type\Executive\Company\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a company data with no field

        $companyData = new Data('{}');

        $this->assertFalse($companyData->isTheaterData);

        // Create a company data with no theater field

        $companyData = new Data([
            'links' => [ 'facebook' => 'coin' ],
            'founded_at' => '2000-01-01'
        ]);

        $this->assertFalse($companyData->isTheaterData);
        $this->assertEquals('coin', $companyData->links->facebook);
        $this->assertEquals(
            new \DateTime('2000-01-01'),
            $companyData->founded_at
        );

        // Create a company data with theater fields

        $companyData = new Data([
            'links' => [ 'facebook' => 'coin' ],
            'founded_at' => '2000-01-01',
            'showtime_source' => 'LEGACY'
        ]);

        $this->assertTrue($companyData->isTheaterData);
        $this->assertEquals('coin', $companyData->links->facebook);
        $this->assertEquals(
            new \DateTime('2000-01-01'),
            $companyData->founded_at
        );

        // Create a company with an invalid field

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [coin] for constrained object [Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data'
        );

        new Data([
            'links' => [ 'facebook' => 'coin' ],
            'founded_at' => '2000-01-01',
            'coin' => 'PAN'
        ]);

    }
}
