<?php

namespace Allocine\DbzModelBundle\Tests\Model;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Allocine\DbzModelBundle\Model\Movie\Movie;
use Allocine\DbzModelBundle\Model\Movie\MovieModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;
use PommProject\ModelManager\Model\Model;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;

class MasterSlaveTest extends KernelTestCase
{
    private static function getSlaveServiceIdList(): array
    {
        return [
            MovieModel::class,
            'dbz.model.movie.movie.slave',
            'dbz.model.movie.movie',
        ];
    }

    private static function getMasterServiceIdList(): array
    {
        return ['dbz.model.movie.movie.master'];
    }

    public function testSlaveModel(): void
    {
        foreach (self::getSlaveServiceIdList() as $servicesId) {
            self::assertSameSessionName(ServiceHelper::BACKEND_SLAVE, static::getContainer()->get($servicesId));
        }

        /** @var \ArrayObject $publicService */
        $publicService = static::getContainer()->get('test.testable_services');
            self::assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[0]);
            self::assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[1]);
            self::assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $publicService[2]);
    }

    public function testMasterModel()
    {
        foreach (self::getMasterServiceIdList() as $servicesId) {
            $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, static::getContainer()->get($servicesId));
        }

        $publicService = static::getContainer()->get('test.testable_services');
        self::assertSameSessionName(ServiceHelper::BACKEND_MASTER, $publicService[3]);
    }

    public function testServicesArePrivate()
    {
        $errors = [];
        foreach(array_merge(self::getSlaveServiceIdList(), self::getMasterServiceIdList()) as $serviceId) {
            try {
                static::$kernel->getContainer()->get($serviceId);
                $errors[] = sprintf(
                    'Retrieving service [%s] should throw a [ServiceNotFoundException], nothing thrown.',
                    $serviceId
                );
            } catch (ServiceNotFoundException $e) {
            } catch (\Exception $e) {
                $errors[] = sprintf(
                    'Retrieving service [%s] should throw a [ServiceNotFoundException], thrown [%s].',
                    $serviceId,
                    get_class($e)
                );
            }
        }

        if (!empty($errors)) {
            $this->fail(implode("\n", $errors));
        } else {
            $this->assertTrue(true);
        }
    }

    private static function assertSameSessionName(string $expected, Model $model): void
    {
        self::assertSame($expected, $model->getSession()->getStamp());
    }
}
