<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\Application as ApplicationStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * ApplicationModel.
 *
 * Model class for table application.
 *
 * @see Model
 */
class ApplicationModel extends ElementModel
{
    use ModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new ApplicationStructure();
        $this->flexibleEntityClass = Application::class;
    }

    /**
     * @param Application $application
     * @param array $config
     *
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function enrichApplicationWithConfig(Application $application, array $config)
    {
        if (isset($config[$application->get('name')])) {
            $application->setConfig($config[$application->get('name')]);
        }
    }
}
