<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Domains\Tag3DCollection;
use PommProject\ModelManager\Model\FlexibleEntity;

/**
 * @property bool active
 * @property \DateTime created_at
 * @property int id_created_by
 * @property \DateTime updated_at
 * @property int id_updated_by
 * @property string origin
 * @property array data
 * @property int id
 * @property string name
 * @property Tag3DCollection tags
 */
class Application extends FlexibleEntity
{
    /**
     * @var array
     */
    private $config = [];

    /**
     * Returns true if the application has access to a specific schema.
     *
     * @param string $name
     *
     * @return bool
     */
    public function isSchemaAccessible(string $name): bool
    {
        return array_key_exists('schemas', $this->config) ? in_array($name, $this->config['schemas']) : false;
    }

    /**
     * @param array $config
     *
     * @return Application
     */
    public function setConfig(array $config)
    {
        $this->config = $config;

        return $this;
    }

    /**
     * @return array
     */
    public function getConfig(): array
    {
        return $this->config;
    }

    /**
     * Returns an array of available schemas for this application.
     *
     * @return array
     */
    public function availableSchemas(): array
    {
        return array_key_exists('schemas', $this->config) ? array_unique($this->config['schemas']) : [];
    }

    /**
     * @return bool
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function isActive()
    {
        return $this->get('active') === true;
    }
}
