<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Festival as FestivalStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * FestivalModel
 *
 * Model class for table festival.
 *
 * @see Model
 */
class FestivalModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new FestivalStructure;
        $this->flexibleEntityClass = Festival::class;
    }
}
