<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;

use Allocine\DbzModelBundle\Model\Brand\AutoStructure\EntityHasAuthor as EntityHasAuthorStructure;

/**
 * EntityHasAuthorModel
 *
 * Model class for table entity_has_author.
 *
 * @see Model
 */
class EntityHasAuthorModel
    extends ElementModel
    implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new EntityHasAuthorStructure;
        $this->flexibleEntityClass = EntityHasAuthor::class;
    }
}
