<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater;

use Allocine\DbzModelBundle\Internal\Converter\Origin;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;
use Allocine\DbzModelBundle\Internal\Type\Generic\Links;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Info;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Executive;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Override;

/**
 * @property Info $info
 * @property Executive $executive
 * @property Origin $showtime_source
 * @property \DateTime $founded_at
 * @property Links $links
 * @property Override $override
 */
class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'info' => [],
            'executive' => [],
            'showtime_source' => null,
            'founded_at' => null,
            'links' => [],
            'override' => [],
            'tech' => null,
            'display_name' => null,
            'showtimes_gathering_method' => null,
            'showtimes_gathering_method_code' => null,
            'showtimes_gathering_method_priority' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'info' => new ClassDefinition([
                'class' => Info::class,
            ]),
            'executive' => new ClassDefinition([
                'class' =>  Executive::class,
            ]),
            'links' => new ClassDefinition([
                'class' => Links::class
            ]),
            'founded_at' => new ClassDefinition([
                'class' => \DateTime::class,
                'nullable' => true,
            ]),
            'override' => new ClassDefinition([
                'class' => Override::class
            ]),
        ];
    }
}
