<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic\Office;

use Allocine\DbzModelBundle\Internal\Type\Generic\Address;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Office extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'name' => null,
            'address' => [],
            'phone' => null,
            'departments' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'address' => new ClassDefinition([
                'class' => Address::class
            ]),
            'departments' => new ClassDefinition([
                'class' => DepartmentCollection::class
            ]),
        ];
    }
}
