<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic;

use Allocine\Titania\Type\Base\ConstrainedObject;

class Coordinates extends ConstrainedObject
{
    const MI_UNIT = 'mi';
    const KM_UNIT = 'km';

    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'longitude' => null,
            'latitude' => null,
        ];
    }

    /**
     * @param Coordinates $from
     *
     * @param string      $unit
     *
     * @return float
     * @throws \Exception
     */
    public function distanceFrom(Coordinates $from, string $unit = self::MI_UNIT): float
    {
        if (!in_array($unit, [self::MI_UNIT, self::KM_UNIT])) {
            throw new \Exception(
                sprintf('Unit "%s" not allowed, allowed units are: %s',
                    $unit,
                    implode(', ', [self::MI_UNIT, self::KM_UNIT])
                )
            );
        }

        $rad = M_PI / 180;

        //Calculate distance from latitude and longitude

        $theta = $from->longitude - $this->longitude;
        $dist =
            sin($from->latitude * $rad) * sin($this->latitude * $rad) +
            cos($from->latitude * $rad) * cos($this->latitude * $rad) *
            cos($theta * $rad);

        $miles = acos($dist) / $rad * 60 * 1.853;

        if ($unit === self::KM_UNIT) {
            return $miles * 1.609344;
        }

        return $miles;
    }
}
