<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use Allocine\DbzModelBundle\Model\Tool\Origin as OriginEnum;
use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Converter\PgString;
use PommProject\Foundation\Session\Session;

class Origin extends PgString
{

    /**
     * fromPg
     *
     * @see ConverterInterface
     */
    public function fromPg($data, string $type, Session $session): ?string
    {
        $data = trim($data);

        if ($data === '') {
            return null;
        }

        if (!in_array($data, [
            OriginEnum::LEGACY,
            OriginEnum::GRAPH_API,
            OriginEnum::WWM_IMPORT,
            OriginEnum::TEST,
            OriginEnum::BOXOFFICE,
            OriginEnum::CORE_IMPORT,
            OriginEnum::GRAPH_ADMIN,
            OriginEnum::CORE,
        ])) {
            throw new \RuntimeException(sprintf(
                'Invalid origin [%s]',
                $data
            ));
        }

        return $data;
    }
}
