<?php

namespace Allocine\DbzModelBundle\Tests\Type\Executive\Company;

use Allocine\DbzModelBundle\Internal\Type\Generic\Office\DepartmentCollection;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DepartmentCollectionTest extends KernelTestCase
{
    public function testGetExistingCompanyNames()
    {
        // Empty collection

        $departmentCollection = new DepartmentCollection([]);

        $this->assertEquals([], $departmentCollection->getExistingDepartmentNames());

        // Full collection

        $departmentCollection = new DepartmentCollection([
            [ 'name' => 'Dept 1' ],
            [ 'name' => 'Dept 2' ],
            [ 'name' => 'Dept 3' ]
        ]);

        $this->assertEquals(
            [
                'Dept 1',
                'Dept 2',
                'Dept 3',
            ],
            $departmentCollection->getExistingDepartmentNames()
        );
    }
}
