<?php

namespace Allocine\DbzModelBundle\Tests\Model\Secure;

use Allocine\DbzModelBundle\Model\Stats\BrandMovieDay;
use Allocine\DbzModelBundle\Model\Stats\BrandMovieDayModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;
use PommProject\Foundation\Where;
use PommProject\ModelManager\Model\FlexibleEntity\FlexibleEntityInterface;

class BrandMovieDayTest extends KernelTestCase
{
    protected $primaryKeys = [
        'id_movie' => 12,
        'day' => '2018-01-02',
        'id_brand' => 'AC',
    ];

    protected function getEntity()
    {
        /** @var BrandMovieDayModel $brandMovieDayModel */
        $brandMovieDayModel = $this->getSession()->getModel(BrandMovieDayModel::class);

        /** @var BrandMovieDay $brandMovieDay */
        $brandMovieDay = $brandMovieDayModel->createEntity();
        $brandMovieDay
            ->setIdMovie(12)
            ->setDay('2018-01-02')
            ->setIdBrand('AC')
            ->setStat([
                'metric' => [
                    'hits' => 12,
                    'advertising_videos' => 47
                ]
            ]);

        return $brandMovieDay;
    }

    public function testInsertOne()
    {
        /** @var BrandMovieDayModel $brandMovieDayModel */
        $brandMovieDayModel = $this->getSession()->getModel(BrandMovieDayModel::class);

        $brandMovieDay = $this->getEntity();
        $brandMovieDayModel->insertOne($brandMovieDay);

        $entity = $brandMovieDayModel->findByPK([
            'id_movie' => 12,
            'day' => '2018-01-02',
            'id_brand' => 'AC',
        ]);

        $this->assertNotNull($entity);
    }

    /**
     * @depends testInsertOne
     */
    public function testUpdateByPk()
    {
        /** @var BrandMovieDayModel $brandMovieDayModel */
        $brandMovieDayModel = $this->getSession()->getModel(BrandMovieDayModel::class);

        $brandMovieDay = $this->getEntity();
        $brandMovieDayModel->insertOne($brandMovieDay);

        $entity = $brandMovieDayModel->findByPK([
            'id_movie' => 12,
            'day' => '2018-01-02',
            'id_brand' => 'AC',
        ]);

        $this->assertNotNull($entity);

        $entity = $brandMovieDayModel->updateByPk($this->primaryKeys, [
            'stats' => [
                'metric' => [
                    'hits' => 16,
                    'advertising_videos' => 60,
                    'sessions' => 12
                ]
            ]
        ]);

        $this->assertSame($entity['stats']['metric']['sessions'], 12);
    }

    /**
     * @depends testInsertOne
     */
    public function testDeleteWhere()
    {
        /** @var BrandMovieDayModel $brandMovieDayModel */
        $brandMovieDayModel = $this->getSession()->getModel(BrandMovieDayModel::class);

        $brandMovieDay = $this->getEntity();
        $brandMovieDayModel->insertOne($brandMovieDay);

        $where = new Where();

        foreach ($this->primaryKeys as $field => $value) {
            $where->andWhere(
                sprintf(
                    "%s = $*::%s",
                    $brandMovieDayModel
                        ->getSession()
                        ->getConnection()
                        ->escapeIdentifier($field),
                    $brandMovieDayModel
                        ->getStructure()
                        ->getTypeFor($field)
                ),
                [$value]
            );
        }

        $entities = $brandMovieDayModel->deleteWhere($where);

        $this->assertCount(1, $entities);
        $this->assertSame($entities->current()->status(), FlexibleEntityInterface::STATUS_NONE);
    }
}
