<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Domains\GlobalId;
use Allocine\DbzModelBundle\Domains\Tag3DCollection;
use Allocine\DbzModelBundle\Internal\Type\Social\User\Data;
use Allocine\DbzModelBundle\Model\Tool\Origin;
use AppBundle\Service\Import\Product\Type\Alternate;
use PommProject\ModelManager\Model\FlexibleEntity;

/**
 * User
 *
 * Flexible entity for relation
 * social.user
 * @property bool active
 * @property \Datetime created_at
 * @property integer id_created_by
 * @property \Datetime updated_at
 * @property integer id_updated_by
 * @property Origin origin
 * @property Data data
 * @property GlobalId gid
 * @property Alternate alt
 * @property string id_brand
 * @property integer id
 * @property string id_legacy
 * @property integer password
 * @property integer salt
 * @property \Datetime last_connection
 * @property string nickname
 * @property string email
 * @property array profile
 * @property Tag3DCollection tags
 * @property string avatar
 * @property bool advertising_consent
 *
 * @see FlexibleEntity
 */
class User extends FlexibleEntity
{
    public static $strict = false;

    /**
     * @return string
     */
    public function getMainAvatar() : ?string
    {
        if (! is_null($this->avatar)) {
            return $this->avatar;
        } elseif (isset($this->profile['url_avatar'])
            &&
            ! is_null($this->profile['url_avatar'])
        ) {
            return $this->profile['url_avatar'];
        } elseif (
            isset($this->profile['social']['facebook']['avatar'])
            &&
            ! is_null($this->profile['social']['facebook']['avatar'])
        ) {
            return $this->profile['social']['facebook']['avatar'];
        } elseif (
            isset($this->profile['social']['google']['avatar'])
            &&
            ! is_null($this->profile['social']['google']['avatar'])
        ) {
            return $this->profile['social']['google']['avatar'];
        }

        return null;
    }
}
