<?php

namespace Allocine\DbzModelBundle\Model\Executive;

use Allocine\DbzModelBundle\Exception\NotFoundException;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Executive\AutoStructure\Localization as LocalizationStructure;
use PommProject\ModelManager\Model\Model;

/**
 * LocalizationModel.
 *
 * Model class for table localization.
 *
 * @see Model
 */
class LocalizationModel extends ElementModel
{
    use ModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new LocalizationStructure();
        $this->flexible_entity_class = Localization::class;
    }

    public function findRegionByCountryAndCode(string $countryId, string $code): Localization
    {
        $result = $this->findWhere(
            'code = $* AND id_country = $* AND type = $*',
            [
                $code,
                $countryId,
                'Localization.Type.Region',
            ]
        )->current();

        if ($result === null) {
            throw new NotFoundException(sprintf('impossible to find Localization with %s', json_encode(['code' => $code, 'id_country' =>  $countryId, 'type' => 'Localization.Type.Region'])));
        }

        return $result;
    }
}
