<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * Video
 *
 * Structure class for relation brand.video_xx.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 *
 *
 *
 * @see RowStructure
 */
class Video extends RowStructure
{
    /**
     * __construct
     *
     * Structure definition.
     *
     * @access public
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.video')
            ->setPrimaryKey(['id'])
            ->addField('id', 'int8')
            ->addField('gid', 'public.global_id')
            ->addField('original_title', 'text')
            ->addField('description_title', 'text')
            ->addField('original_generated_title', 'text')
            ->addField('duration', 'interval')
            ->addField('id_snapshot', 'int8')
            ->addField('tags', 'public.tag3d_array')
            ->addField('starts_at', 'timestamp')
            ->addField('ends_at', 'timestamp')
            ->addField('url', 'text')
            ->addField('html', 'text')
            ->addField('alt', 'jsonb')
            ->addField('original_data', 'jsonb')
            ->addField('localized_title', 'text')
            ->addField('localized_description', 'text')
            ->addField('localized_generated_title', 'text')
            ->addField('localized_data', 'jsonb')
            ->addField('updated_at', 'timestamp')
            ->addField('id_certificate', 'int8')
        ;
    }
}
