<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class NextOpening
 *
 * @property \DateTime $starts_at
 */
class NextOpening extends ConstrainedObject
{
    const DATE_FORMAT = 'Y-m-d';

    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'starts_at' => null,
            'message' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'starts_at' => new ClassDefinition([
                'class' => \DateTime::class,
                'nullable' => true,
            ]),
        ];
    }

    /**
     * Change date to date-only format
     *
     * @param bool $compress
     * @return string
     */
    public function toJSon($compress = true)
    {
        $simpleObject = $this->toSimpleObject();

        $simpleObject->starts_at = $this->starts_at->format(self::DATE_FORMAT);

        return json_encode($simpleObject);
    }
}
