<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\User\Data;

use Allocine\DbzModelBundle\Domains\Tag3D;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property string badge
 * @property \DateTime created_at
 */
class Badge extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'badge' => null,
            'created_at' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'badge' => new ClassDefinition([
                'class' => Tag3D::class,
            ]),
            'created_at' => new ClassDefinition([
                'class' => \DateTime::class,
            ]),
        ];
    }
}
