<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Series\SeriesSeasonHasRelease;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Series\SeriesSeasonHasRelease\Data
    as DataType;

class Data implements ConverterInterface
{
    /**
     * {@inheritdoc}
     */
    public function fromPg($data, $type, Session $session)
    {
        return new DataType($data);
    }

    /**
     * {@inheritdoc}
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * {@inheritdoc}
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
