<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Movie\MovieHasRelease;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Movie\MovieHasRelease\Data as DataType;

class Data implements ConverterInterface
{
    /**
     * {@inheritdoc}
     */
    public function fromPg($data, $type, Session $session)
    {
        return new DataType($data);
    }

    /**
     * {@inheritdoc}
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * {@inheritdoc}
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
