<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use Allocine\DbzModelBundle\Internal\Type\Generic\Link as DataType;
use PommProject\Foundation\Converter\PgJson;
use PommProject\Foundation\Session\Session;

class Link extends PgJson
{
    /**
     * {@inheritdoc}
     */
    public function fromPg($data, $type, Session $session)
    {
        return new DataType($data);
    }

    /**
     * toPg
     *
     * @param $data
     * @param $type
     * @param Session $session
     * @return string
     * @throws \PommProject\Foundation\Exception\ConverterException
     * @see ConverterInterface
     */
    public function toPg($data, $type, Session $session)
    {
        if ($data === null) {
            return sprintf("NULL::%s", $type);
        } else {
            $this->checksContraint($data);

            return sprintf(
                '%s::jsonb',
                $session->getConnection()->escapeLiteral($data->toJson(true))
            );
        }
    }

    /**
     * toPgStandardFormat
     *
     * @param $data
     * @param $type
     * @param Session $session
     * @return string
     * @throws \PommProject\Foundation\Exception\ConverterException
     * @see ConverterInterface
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        if ($data === null) {
            return sprintf("NULL::%s", $type);
        } else {
            $this->checksContraint($data);

            return sprintf(
                '%s::jsonb',
                $session->getConnection()->escapeLiteral($data->toJson(true))
            );
        }
    }

    /**
     * @param $data
     * @throws \PommProject\Foundation\Exception\ConverterException
     * @throws \RuntimeException
     */
    private function checksContraint($data)
    {
        if (($data->url === null) && ($data->route === null)) {
            throw new \RuntimeException(sprintf(
                'Missing url or route for link %s',
                $data->toJson()
            ));
        }

        if (($data->url !== null) && ($data->route !== null)) {
            throw new \RuntimeException(sprintf(
                'Both url and route are defined for link %s',
                $data->toJson()
            ));
        }
    }
}
