<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserFollowUserModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserFollowUserModelTest extends KernelTestCase
{
    /**
     * @var UserFollowUserModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserFollowUserModel::class)
        ;
    }

    /**
     *
     */
    public function testCountByUser()
    {
        $expected = [
            2000000000 => 3,
            2000000001 => 2,
            2000000002 => 0,
            2000000003 => 0,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByPublisher($user)
            );
        }

        $expected = [
            2000000000 => 0,
            2000000001 => 1,
            2000000002 => 2,
            2000000003 => 2,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByFollower($user)
            );
        }
    }

}
