<?php

namespace Allocine\DbzModelBundle\Test\Pomm\Foundation\PreparedQuery;

use PommProject\Foundation\Client\ClientInterface;
use PommProject\Foundation\Exception\FoundationException;
use PommProject\Foundation\PreparedQuery\PreparedQueryPooler as PreparedQueryPoolerBase;

class PreparedQueryPooler extends PreparedQueryPoolerBase
{
    /**
     * @throws FoundationException
     * @see    ClientPooler
     */
    protected function getClientFromPool(string $identifier): ?ClientInterface
    {
        return $this
            ->getSession()
            ->getClient($this->getPoolerType(), PreparedQuery::getSignatureFor($identifier));
    }

    /**
     * @throws FoundationException
     * @see    ClientPooler
     */
    public function createClient(string $identifier): PreparedQuery
    {
        return new PreparedQuery($identifier);
    }
}
