<?php

namespace Allocine\DbzModelBundle\Model\Core;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\FlexibleEntity\FlexibleEntityInterface;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Core\AutoStructure\FestivalJury as FestivalJuryStructure;

/**
 * FestivalJuryModel
 *
 * Model class for table festival_jury.
 * @method FestivalJuryStructure getStructure()
 * @see Model
 */
class FestivalJuryModel extends ElementModel
{
    use ModelTrait;

    public function __construct()
    {
        $this->structure = new FestivalJuryStructure();
        $this->flexibleEntityClass = FestivalJury::class;
    }

    public function createAndSave(array $values): FlexibleEntityInterface
    {
        $values['active'] = true;

        return parent::createAndSave($values);
    }
}
