<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * EntityFlag.
 *
 * Structure class for relation brand.series.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class EntityFlag extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.entity_flag')
            ->setPrimaryKey(['gid_entity'])
            ->addField('gid_entity', 'public.global_id')
            ->addField('last_updated_at', 'timestamp')
            ->addField('flag', 'brand.entity_flag.flag')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor(string $name): string
    {
        if (in_array($name, [ 'flag' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }
}
