<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater;

use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Transportation\PlaceCollection;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Transportation extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'bus' => [],
            'metro' => [],
            'rapidtransit' => [],
            'tramway' => [],
            'localtrain' => [],
            'coach' => [],
            'ferry' => [],
            'train' => [],
            'railshuttle' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'bus' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'metro' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'rapidtransit' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'tramway' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'localtrain' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'coach' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'ferry' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'train' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
            'railshuttle' => new ClassDefinition([
                'class' => PlaceCollection::class,
                'nullable' => true,
            ]),
        ];
    }
}
