<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Social\UserHasReview;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Stats as StatsType;

class Stats implements ConverterInterface
{
    /**
     * {@inheritdoc}
     */
    public function fromPg(?string $data, string $type, Session $session): mixed
    {
        return new StatsType($data);
    }

    /**
     * {@inheritdoc}
     */
    public function toPg($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * {@inheritdoc}
     */
    public function toPgStandardFormat($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
