<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Data\DataWithSeo
    as DataWithSeoType;

class DataWithSeo implements ConverterInterface
{
    /**
     * @inheritdoc
     */
    public function fromPg($dataWithSeo, string $type, Session $session): mixed
    {
        return new DataWithSeoType($dataWithSeo);
    }

    /**
     * @inheritDoc
     */
    public function toPg($dataWithSeo, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($dataWithSeo->toJson())
        );
    }

    /**
     * @inheritDoc
     */
    public function toPgStandardFormat($dataWithSeo, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($dataWithSeo->toJson())
        );
    }
}
