<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Internal\Model\PartitionWriteQueries;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandMovieDay as BrandMovieDayStructure;
use Allocine\DbzModelBundle\Model\Stats\BrandMovieDay;

/**
 * BrandMovieDayModel
 *
 * Model class for table brand_movie_day.
 *
 * @see Model
 */
class BrandMovieDayModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries, PartitionWriteQueries {
        PartitionWriteQueries::insertOne insteadof WriteQueries;
        PartitionWriteQueries::updateByPk insteadof WriteQueries;
        PartitionWriteQueries::deleteWhere insteadof  WriteQueries;
    }
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandMovieDayStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Stats\BrandMovieDay';
    }
}
